Imports System.Drawing

'
' All elements of a document belong to a subclass of this
' abstract class.
'
Public MustInherit Class AbstractDocumentElement
    Implements IDocumentElement
    ' This is the font associated with this object.  If the
    ' font variable is Nothing, then this object's font will be
    ' inherited through the container hierarchy from an
    ' enclosing object.
    Private myFont As Font

    ' This object's container
    Private myParent As CompositeDocumentElement

    ' The name of the style that applies to this object or Nothing.
    Private myStyle As String

    ' this object's parent or Nothing if it has no parent
    Public Property Parent() As CompositeDocumentElement _
     Implements IDocumentElement.Parent
        Get
            Return myParent
        End Get
        Set(ByVal Value As CompositeDocumentElement)
            myParent = Value
        End Set
    End Property

    ' the Font associatiated with this object
    Public Property Font() As Font _
     Implements IDocumentElement.Font
        Get
            If myFont IsNot Nothing Then
                Return myFont
            ElseIf Parent IsNot Nothing Then
                Return Parent.myFont
            Else
                Return Nothing
            End If
        End Get
        Set(ByVal Value As Font)
            myFont = Value
        End Set
    End Property

    ' number of characters that this object contains
    Public MustOverride ReadOnly _
     Property CharLength() As Integer _
        Implements IDocumentElement.CharLength

    ' name of the style that applies to this object or Nothing
    Public Property Style() As String _
            Implements IDocumentElement.Style
        Get
            Return myStyle
        End Get
        Set(ByVal Value As String)
            myStyle = Value
        End Set
    End Property
End Class 'AbstractDocumentElement